﻿Imports System.ComponentModel


''' <summary>
''' Provide the definition of the top most item in a 
''' DataTreeView.
''' </summary>
''' <remarks>
''' This is used to provide for instances where there is
''' no selection in the tree or to allow for the data that
''' is bound to the DataTreeView to be cleared.
''' </remarks>
<TypeConverter(GetType(TopMostNodeConverter)) _
, Serializable() _
, Browsable(True)> _
Public Class TopMostTreeNode

#Region "   Constructors "

  ''' <summary>
  ''' Construct a default instance.
  ''' </summary>
  ''' <remarks></remarks>
  Public Sub New()
  End Sub

  ''' <summary>
  ''' Construct an instance with the data set.
  ''' </summary>
  ''' <param name="text"></param>
  ''' <param name="id"></param>
  ''' <remarks></remarks>
  Public Sub New(ByVal text As String, ByVal id As Integer)
    Me.TopMostText = text
    Me.TopMostID = id
  End Sub

#End Region

#Region "   Properties "

  Private _topMostText As String = String.Empty

  ''' <summary>
  ''' Define the text displayed by the node for the top
  ''' most item.
  ''' </summary>
  ''' <value></value>
  ''' <returns></returns>
  ''' <remarks></remarks>     
  <Description("The text to display for the top most node.") _
  , DefaultValue("") _
  , NotifyParentProperty(True) _
  , RefreshProperties(RefreshProperties.All)> _
  Public Property TopMostText() As String
    Get
      Return _topMostText
    End Get
    Set(ByVal value As String)
      _topMostText = value
    End Set
  End Property

  Private _topMostID As Integer

  ''' <summary>
  ''' Define the value of the ID of the top most node.
  ''' </summary>
  ''' <value></value>
  ''' <returns></returns>
  ''' <remarks></remarks>     
  <Description("The ID that is used for the top most node.") _
  , DefaultValue(0) _
  , NotifyParentProperty(True) _
  , RefreshProperties(RefreshProperties.All)> _
  Public Property TopMostID() As Integer
    Get
      Return _topMostID
    End Get
    Set(ByVal value As Integer)
      _topMostID = value
    End Set
  End Property

#End Region

#Region "   Override Methods "

  ''' <summary>
  ''' Return the text and ID for the item.
  ''' </summary>
  ''' <returns></returns>
  ''' <remarks></remarks>
  Public Overrides Function ToString() As String
    Return String.Format("{0},{1}", Me.TopMostText, Me.TopMostID)
  End Function

#End Region

End Class
