﻿Imports System.ComponentModel

''' <summary>
''' Provide a type converter for the TopMostNode object.  This 
''' supports converting to/from strings.
''' </summary>
''' <remarks></remarks>
Public Class TopMostNodeConverter
  Inherits ExpandableObjectConverter

#Region "   Properties "

  Private _emptyItemString As String = "<text>,<ID>"

  ''' <summary>
  ''' Define the string used to indicate that there is no 
  ''' TopMostNode defined.
  ''' </summary>
  ''' <value></value>
  ''' <returns></returns>
  ''' <remarks></remarks>     
  Public Property EmptyItemString() As String
    Get
      Return _emptyItemString
    End Get
    Set(ByVal value As String)
      _emptyItemString = value
    End Set
  End Property

#End Region

#Region "   TypeConverter Overrides "

  ''' <summary>
  ''' Determine if the indicated source type can be converted by 
  ''' this class to a TopMostNode object.
  ''' </summary>
  ''' <param name="context"></param>
  ''' <param name="sourceType"></param>
  ''' <returns></returns>
  ''' <remarks></remarks>
  Public Overrides Function CanConvertFrom(ByVal context As System.ComponentModel.ITypeDescriptorContext, ByVal sourceType As System.Type) As Boolean
    '-- Establish a return var
    Dim canConvert As Boolean

    '-- If the type is a string, then we are good to go
    If sourceType.Equals(GetType(System.String)) Then
      canConvert = True
    Else
      canConvert = MyBase.CanConvertFrom(context, sourceType)
    End If

    '-- Return if we can convert
    Return canConvert
  End Function

  ''' <summary>
  ''' Determine if the indicated destination type is a type that 
  ''' this converter can convert a TopMostNode object into.
  ''' </summary>
  ''' <param name="context"></param>
  ''' <param name="destinationType"></param>
  ''' <returns></returns>
  ''' <remarks></remarks>
  Public Overrides Function CanConvertTo(ByVal context As System.ComponentModel.ITypeDescriptorContext, ByVal destinationType As System.Type) As Boolean
    '-- Establish a return var
    Dim canConvert As Boolean

    '-- If the type is a string, then we are good to go
    If destinationType.Equals(GetType(System.String)) Then
      canConvert = True
    Else
      canConvert = MyBase.CanConvertTo(context, destinationType)
    End If

    Return canConvert
  End Function

  ''' <summary>
  ''' Convert a string into a TopMostNode object
  ''' </summary>
  ''' <param name="context"></param>
  ''' <param name="culture"></param>
  ''' <param name="value"></param>
  ''' <returns></returns>
  ''' <remarks></remarks>
  Public Overrides Function ConvertFrom(ByVal context As System.ComponentModel.ITypeDescriptorContext, ByVal culture As System.Globalization.CultureInfo, ByVal value As Object) As Object
    '-- Establish a return var
    Dim top As New TopMostTreeNode()

    '-- If the value is nothing or an empty string, return nothing
    If String.IsNullOrEmpty(CType(value, String)) Then Return top

    '-- If the value is simply a comma, return nothing
    If CType(value, String) = Me.EmptyItemString Then Return top

    '-- If the value to convert from is a string, 
    If value.GetType() Is GetType(System.String) Then
      '-- Convert to string
      Dim valueText As String = CType(value, String)

      '-- Validate that the format is correct. The format accepted is 
      '   the text followed by a comma and the value:
      '      text,value
      '   We need the comma mainly, and only one.
      Dim firstCommaPos As Integer = valueText.IndexOf(",")
      If firstCommaPos < 0 _
              OrElse _
         (firstCommaPos < valueText.Length() - 1 AndAlso valueText.IndexOf(",", firstCommaPos + 1) >= 0) Then
        Throw New ArgumentException("The indicated string is not a valid TopMostNode string.", "value")
      End If

      '-- Parse string 
      Dim text As String = valueText.Substring(0, firstCommaPos)
      Dim id As Integer
      If firstCommaPos <> valueText.Length() - 1 Then
        id = CInt(valueText.Substring(firstCommaPos + 1))
      End If

      '-- Load properties.
      top.TopMostID = id
      top.TopMostText = text
    Else
      '-- Use default type converter
      Return MyBase.ConvertFrom(context, culture, value)
    End If

    '-- Return the top most node
    Return top
  End Function

  ''' <summary>
  ''' Convert a TopMostNode object into a string.
  ''' </summary>
  ''' <param name="context"></param>
  ''' <param name="culture"></param>
  ''' <param name="value"></param>
  ''' <param name="destinationType"></param>
  ''' <returns></returns>
  ''' <remarks></remarks>
  Public Overrides Function ConvertTo(ByVal context As System.ComponentModel.ITypeDescriptorContext, ByVal culture As System.Globalization.CultureInfo, ByVal value As Object, ByVal destinationType As System.Type) As Object
    '-- The provided value must be a TopMostNode and the destination 
    '   type must be a string
    If destinationType.Equals(GetType(System.String)) Then
      If value Is GetType(TopMostTreeNode) Then
        Return value.ToString()
      Else
        Return Me.EmptyItemString
      End If
    Else
      '-- Just use the standard converter
      Return MyBase.ConvertTo(context, culture, value, destinationType)
    End If
  End Function

#End Region

End Class

