﻿Imports System.ComponentModel

''' <summary>
''' Extende the tree to include a top most node.
''' </summary>
''' <remarks></remarks>
Public Class ExtendedTreeView
  Inherits System.Windows.Forms.TreeView

#Region "   Properties "

  Private _topMostNode As TopMostTreeNode

  ''' <summary>
  ''' Define the top most node for the tree view.
  ''' </summary>
  ''' <value></value>
  ''' <returns></returns>
  ''' <remarks>
  ''' This is typically used to indicate an item that indicates 
  ''' there is nothing selected.
  ''' </remarks>
  <Category("RAMS: Item Population") _
  , Description("Define the text and ID that is used for the top most node. This is often used to indicate no selection and/or to allow for the clearing of a selection, when the tree is bound.") _
  , DesignerSerializationVisibility(DesignerSerializationVisibility.Content)> _
  Public Property TopMostNode() As TopMostTreeNode
    Get
      Return _topMostNode
    End Get
    Set(ByVal value As TopMostTreeNode)
      _topMostNode = value
    End Set
  End Property

#Region "     Designer Support "

  ''' <summary>
  ''' Return if the designer should serialize the TopMostNode 
  ''' property.
  ''' </summary>
  ''' <returns>True if property needs to be serialized to the designer</returns>
  ''' <remarks></remarks>     
  Public Function ShouldSerializeTopMostNode() As Boolean
    Return _topMostNode IsNot Nothing
  End Function

  ''' <summary>
  ''' Reset the TopMostNode to its default value and remove serialization
  ''' the property from the designer.
  ''' </summary>
  ''' <remarks></remarks>     
  Public Sub ResetTopMostNode()
    _topMostNode = Nothing
  End Sub

#End Region

#End Region

End Class
